#include <stdio.h>
#include <dos.h>

#define    IN_BUF_SIZE      1024
#define    NoError	    0
#define    InitPinIsOpen    0
#define    InitPinIsNotOpen 1
#define    QueueIsEmpty     0
#define    QueueIsNotEmpty  1
#define    PortError	   -1
#define    DataError	   -2
#define    ParityError	   -3
#define    StopError	   -4
#define    TimeOut	   -5
#define    QueueEmpty	   -6
#define    QueueOverflow   -7
#define    PosError	   -8
#define    AddrError	   -9
#define    BlockError	   -10
#define    WriteError	   -11
#define    SegmentError    -12
#define    BaudRateError   -13
#define    CheckSumError   -14
#define    ChannelError    -15
#define    TimeIsUp        1

#define    CtsPinIsInactive 0	//990116
#define    CtsPinIsactive   1
#define    DsrPinIsInactive 0
#define    DsrPinIsactive   1


void InitLib(void); /*do nothing, can be omitted */
int  InstallCom(int port, unsigned long baud, int data, int parity, int stop);
int  RestoreCom(int port);
int  IsCom(int port);
int  ReadCom(int port);
int  ToCom(int port, int data);
int  ClearCom(int port);
int  WaitTransmitOver(int port);


int IsCom1OutBufEmpty(void);
int IsCom2OutBufEmpty(void);
int DataSizeInCom(int port);

void SetFlowControlActive(void);
void SetFlowControlInactive(void);

char hex_to_ascii(int iHex);  //990116
int ascii_to_hex(char ascii);

int SendCmdTo9000(int iPort, unsigned char *cCmd, int iChksum);
int ReceiveResponseFrom9000(int iPort, unsigned char *cCmd, long lTimeout, int iChksum);

int  ReadInitPin(void);
void LedOff(void);
void LedOn(void);
void Init5DigitLed(void);
int  Show5DigitLed(int position, int value);
int Show5DigitLedSeg(int pos,int value);
void DelayTimeMs(unsigned int time);

int  ReadNVRAM(int addr);
int  WriteNVRAM(int addr, int data);

void InitRTC (void);
void ReadTimeAndShow(void);

int  WriteEEP(int block, int addr, int data);
int  ReadEEP(int block, int addr);
void EnableEEP(void);
void ProtectEEP(void);

void far *_MK_FP(unsigned segment,unsigned offset);
int IsResetByWatchDogTimer(void);
int IsResetByPowerOff(void); 

int SetupWatchdogISR(void);
void EnableWatchDogNMI(void);

void EnableWDT(void);
void RefreshWDT(void);
void DisableWDT(void);

int FlashReadId(void);
int FlashWrite(unsigned int seg, unsigned int offset, char data);
int FlashErase(unsigned int seg);
int FlashRead(unsigned int seg, unsigned int offset);

void Delay(unsigned ms);
void Delay_1(unsigned ms);

int getch4(void);
int kbhit4(void);
int ungetch4(int key);
void putch4(int data); 


int Show5DigitLedWithDot(int pos, int data);
void Set5DigitLedTestMode(int mode);
void Set5DigitLedIntensity(int mode);
void Disable5DigitLed(void);
void Enable5DigitLed(void);
unsigned GetLibVersion(void);

int TimerOpen(void);
int TimerClose(void);
void TimerResetValue(void);
unsigned long TimerReadValue(void);
void DelayMs(unsigned t);
int StopWatchReset(int channel);
int StopWatchStart(int channel);
int StopWatchStop(int channel);
int StopWatchPause(int channel);
int StopWatchContinue(int channel);
int StopWatchReadValue(int channel,unsigned long *value);
int CountDownTimerStart(int channel,unsigned long count);
int CountDownTimerReadValue(int channel,unsigned long *value);
void InstallUserTimer(void (*fun)(void));
void InstallUserTimer1C(void (*fun)(void));

void SetDtrActive(void);	//990116
void SetDtrInactive(void);
void SetRtsActive(void);
void SetRtsInactive(void);

int GetCtsStatus(void);
int GetDsrStatus(void);



